﻿#pragma once
#include "Resource.h"

namespace RTCam {

// A texture that shaders can read.
class Texture : public Resource
{
public:
	explicit Texture(_In_z_ const char* name);
	~Texture(void);

	void InitFromDDS(_In_ ID3D11Device1* device, _In_z_ const char* filename);

	virtual void ReleaseResources();

	size_t GetWidth() const;
	size_t GetHeight() const;

	ComPtr<ID3D11Texture2D> m_texture;
	ComPtr<ID3D11ShaderResourceView> m_shaderView;

protected:
	void InitTexture(_In_ ID3D11Device1* device, size_t width, size_t height, DXGI_FORMAT texFormat, DXGI_FORMAT srvFormat, int bindFlags, bool mipmapEnabled = false);

	size_t m_width;
	size_t m_height;

private:
	bool m_mipmapEnabled;
};

} // end namespace